<?php

namespace Drupal\gift_aid\Form\Donor;

use Drupal\Core\Entity\ContentEntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Provides a form for cancelling gift aid declarations.
 *
 * @ingroup gift_aid
 */
class DonorCancelForm extends ContentEntityConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Cancel Gift Aid');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('Are you sure you want to cancel Gift Aid for all future donations?');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelText() {
    return $this->t('Go back');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    $route_match = $this->getRouteMatch();
    return Url::fromRoute(substr($route_match->getRouteName(), 0, -strlen('.cancel')), $route_match->getRawParameters()->all());
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $donor = $this->entity;

    $evidence = \Drupal::entityTypeManager()->getStorage('gift_aid_evidence')->create(['type' => 'web']);
    $evidence->save();

    $cancellation = \Drupal::entityTypeManager()->getStorage('gift_aid_cancellation')->create();
    $cancellation->setDonor($donor)
      ->setEvidence($evidence)
      ->save();

    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
