<?php

namespace Drupal\gift_aid\Form\Evidence;

use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Builds the form to delete Evidence type entities.
 */
class EvidenceTypeDeleteForm extends EntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $evidence_count = $this->entityTypeManager->getStorage('gift_aid_evidence')->getQuery()
      ->accessCheck(FALSE)
      ->condition('type', $this->entity->id())
      ->count()
      ->execute();
    if ($evidence_count) {
      $caption = '<p>' . $this->formatPlural($evidence_count, '%label is used by 1 evidence on your site. You can not remove this evidence type until you have removed all of the %label evidence.', '%label is used by @count evidence on your site. You may not remove %label until you have removed all of the %label evidence.', ['%label' => $this->entity->label()]) . '</p>';
      $form['description'] = ['#markup' => $caption];
      return $form;
    }
    else {
      return parent::buildForm($form, $form_state);
    }
  }

}
