<?php

namespace Drupal\gift_aid;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Dynamic permissions for Gift Aid module.
 */
class GiftAidPermissions implements ContainerInjectionInterface {

  use StringTranslationTrait;

  /**
   * Constructor for MyModulePermissions.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(protected readonly EntityTypeManagerInterface $entityTypeManager) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static($container->get('entity_type.manager'));
  }

  /**
   * Get permissions for MyModule.
   *
   * @return array
   *   Permissions array.
   */
  public function permissions() {
    $permissions = [];

    foreach ($this->entityTypeManager->getStorage('gift_aid_declaration_type')->loadMultiple() as $type) {
      if ($type->getMethod() != 'web') {
        $permissions['create ' . $type->id() . ' declarations'] = [
          'title' => $this->t('Create %type declarations', ['%type' => $type->label()]),
        ];
      }
    }

    return $permissions;
  }

}
