<?php

namespace Drupal\gift_aid\Plugin\Validation\Constraint;

use Drupal\Core\Entity\Plugin\Validation\Constraint\CompositeConstraintBase;

/**
 * Validates start_date field of the gift aid entity.
 *
 * @Constraint(
 *   id = "GiftAidStartDate",
 *   label = @Translation("Start date", context = "Validation"),
 *   type = {"entity:gift_aid_declaration","entity:gift_aid_cancellation"}
 * )
 */
class StartDateConstraint extends CompositeConstraintBase {

  /**
   * Message shown when the start_date field is empty in a date-based record.
   *
   * @var string
   */
  public $messageRequiredIfDateBased = 'A start date must be provided if the record is date-based.';

  /**
   * {@inheritdoc}
   */
  public function coversFields() {
    return ['start_date'];
  }

}
