<?php

namespace Drupal\gift_aid\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the GiftAidDeclarationStartDate constraint.
 */
class StartDateConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate($entity, Constraint $constraint) {
    if ($entity->hasField('date_based') && $entity->hasField('start_date')) {
      $date_based = (bool) $entity->get('date_based')->value;

      // Do not allow non-empty start_date field if declaration is date-based.
      if ($date_based && $entity->get('start_date')->isEmpty()) {
        $this->context->buildViolation($constraint->messageRequiredIfDateBased)
          ->atPath('start_date')
          ->addViolation();
      }
    }
  }

}
