<?php

namespace Drupal\Tests\gift_aid\Kernel;

use Drupal\gift_aid\Entity\Charity;
use Drupal\gift_aid\Entity\CharityInterface;

/**
 * Tests the charity entity.
 *
 * @coversDefaultClass \Drupal\gift_aid\Entity\Charity
 * @group gift_aid
 */
class CharityTest extends GiftAidTestBase {

  /**
   * Tests CRUD operations.
   *
   * @covers ::getName
   * @covers ::getRegisteredName
   * @covers ::getRegistrationNumber
   * @covers ::getRegisteredAddress
   * @covers ::setName
   * @covers ::setRegisteredName
   * @covers ::setRegistrationNumber
   * @covers ::setRegisteredAddress
   */

  /**
   * Tests the updating of a charity.
   */
  public function testUpdate() {
    $this->charity->setName('My name');
    $this->charity->setRegisteredName('My registered name');
    $this->charity->setRegistrationNumber('My registration number');
    $this->charity->setRegisteredAddress([
      'country_code' => 'uk',
      'postal_code' => 'B11 1AA',
      'address_line1' => 'My address',
    ]);
    $this->charity->save();
    $this->charity = Charity::load($this->charity->id());

    $this->assertEquals($this->charity->getName(), 'My name', 'Charity name updated.');
    $this->assertEquals($this->charity->getRegisteredName(), 'My registered name', 'Registered name updated.');
    $this->assertEquals($this->charity->getRegistrationNumber(), 'My registration number', 'Registration number updated.');
    $this->assertEquals($this->charity->getRegisteredAddress()->getAddressLine1(), 'My address', 'Registered address updated.');
  }

  /**
   * Tests the deleting of charity.
   */
  public function deleteTests() {
    $charity = Charity::load($this->charity->id());
    $this->assertTrue($charity instanceof Charity, 'The loaded entity is a charity.');
    $charity->delete();
    $charity = Charity::load($this->charity->id());
    $this->assertTrue(is_null($charity), 'The charity deleted.');
  }

  /**
   * Test the loadDefault storage method.
   */
  public function testLoadDefault() {
    $storage = \Drupal::entityTypeManager()->getStorage('gift_aid_charity');
    $this->assertInstanceOf(CharityInterface::class, $storage->loadDefault());

    $this->charity->setDefault(FALSE)->save();
    $this->assertNull($storage->loadDefault());
  }

}
