<?php

namespace Drupal\Tests\gift_aid\Traits;

/**
 * Helper methods for gift aid kernel tests.
 */
trait GiftAidKernelTestTrait {

  use GiftAidTestTrait;

  /**
   * A sample user.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $user;

  /**
   * Install for kernel tests.
   */
  protected function giftAidKernelSetUp(): void {
    // Install schemas and configs.
    $this->installEntitySchema('gift_aid_charity');
    $this->installEntitySchema('gift_aid_donor');
    $this->installEntitySchema('gift_aid_declaration_type');
    $this->installEntitySchema('gift_aid_declaration');
    $this->installEntitySchema('gift_aid_evidence_type');
    $this->installEntitySchema('gift_aid_evidence');
    $this->installConfig(['gift_aid', 'user']);

    // Install required default configuration for filter module.
    $this->installConfig(['system', 'filter']);

    $this->createGiftAidDefaultEntities();
    $this->container->get('current_user')->setAccount($this->user);
  }

}
