<?php
/**
 * @file
 * Contains \Drupal\gin_login\Theme\ThemeNegotiator
 * Credit to jimconte https://jimconte.com/blog/web/dynamic-theme-switching-in-drupal-8
 */
namespace Drupal\gin_login\Theme;

use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Theme\ThemeNegotiatorInterface;

class ThemeNegotiator implements ThemeNegotiatorInterface {

    /**
     * @param RouteMatchInterface $route_match
     * @return bool
     */
    public function applies(RouteMatchInterface $route_match)
    {
        return $this->negotiateRoute($route_match) ? true : false;
    }

    /**
     * @param RouteMatchInterface $route_match
     * @return null|string
     */
    public function determineActiveTheme(RouteMatchInterface $route_match)
    {
        return $this->negotiateRoute($route_match) ?: null;
    }

    /**
     * Function that does all of the work in selecting a theme
     * @param RouteMatchInterface $route_match
     * @return bool|string
     */
    private function negotiateRoute(RouteMatchInterface $route_match)
    {
        $userRolesArray = \Drupal::currentUser()->getRoles();

        if (
          $route_match->getRouteName() == 'user.login' ||
          $route_match->getRouteName() == 'user.pass' ||
          $route_match->getRouteName() == 'user.register'
        ) {
            return 'claro';
        }

        return false;
    }

}
