((Drupal, once) => {
  Drupal.behaviors.giveCiviCrmWebform = {
    attach(context) {
      once('giveCiviCrmWebform', '.give-civicrm-webform', context).forEach((webform) => {
        const opts = webform.querySelectorAll('input.amount-option-radio');
        opts.forEach(opt => {
          opt.addEventListener('change', (e) => {
            amt = webform.querySelector('input.civicrm-enabled.contribution-line-item');
            amt.value = e.target.value;
          });
        });

        const contributionLineItem = webform.querySelectorAll('.contribution-line-item');    
        contributionLineItem.forEach(lineItem => {
          lineItem.addEventListener('input', (e) => {
            const optionsField = e.target.parentElement.querySelector(".amount-options");
            const buttons = optionsField.querySelectorAll("input");
            buttons.forEach(button => {
              button.checked = false;
            })
          });
        })

      });
    }
  };
})(Drupal, once);

