<?php

namespace Drupal\give_civicrm_webform\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;

final class FormAlter {

  /**
   * Implements hook_form_alter().
   */
  #[Hook('form_alter')]
  public function formAlter(array &$form, FormStateInterface $formState, $form_id) {
    // There's got to be a hook that targets webform submission forms better.
    if (!isset($form['#webform_id'])) {
      // Bail immediately with no action if we are not altering a webform.
      return;
    }
    if (!isset($form['elements']['contact_pagebreak'])) {
      // We attach our JS only to the contact step, not the pay step.
      // … but this is present in both cases, we'll have to dig deeper.
      // For now it is at least more carefully targetting our webform overall.
      return;
    }
    $form['#attributes']['class'][] = 'give-civicrm-webform';
    $form['#attached']['library'][] = 'give_civicrm_webform/give_civicrm_webform';
    // Pre-load stripe.
    $form['#attached']['library'][] = 'give_civicrm_webform/stripe';

  }

}