# Glide.js Module

This module provides a **Views Style plugin** for Drupal, allowing you to display any view as a responsive, touch-friendly **Glide.js carousel or slider**.

## Features

- Display Views rows as a **slider** or **carousel**.
- Autoplay with optional hover pause.
- Keyboard navigation support.
- Touch and swipe support with configurable thresholds.
- Rewind and bound options.
- Animation duration and easing configuration.
- Responsive breakpoints support.

## Drupal Installation

For instructions on enabling and installing Drupal modules, see the official guide:  
[https://www.drupal.org/docs/creating-custom-modules](https://www.drupal.org/docs/creating-custom-modules)

## Glide.js Documentation

Full documentation for Glide.js options and configuration can be found here:  
[https://glidejs.com/docs/](https://glidejs.com/docs/)

## Configuration

- Add or edit a **View**.
- Select **Glide Carousel** as the display format.
- Configure options such as:
    - Type (`slider` / `carousel`)
    - Slides per view
    - Autoplay speed and hover pause
    - Swipe / drag options
    - Animation duration and easing
    - Rewind settings
    - Responsive breakpoints
    - etc...
