/**
 * @file
 * Initializes Glide.js sliders for Views with proper configuration.
 */

/* global Glide */

(function (Drupal, drupalSettings) {
  /**
   * Drupal behavior for initializing Glide.js sliders.
   */
  Drupal.behaviors.glideInit = {
    attach(context) {
      // Find all sliders in the current context.
      const sliders = context.querySelectorAll('.js-glide-view');

      sliders.forEach((slider) => {
        // Retrieve view and display IDs from data attributes.
        const viewId = slider.dataset.glideViewId;
        const displayId = slider.dataset.glideDisplayId;

        // Retrieve Glide configuration from drupalSettings.
        const config = drupalSettings.glidejs?.[viewId]?.[displayId];
        if (!config) {
          return;
        }

        // Initialize Glide with settings from Drupal.
        // Assumes that options are validated server-side.
        const glide = new Glide(slider, {
          type: config.type,
          startAt: config.startAt,
          perView: config.perView,
          focusAt: config.focusAt,
          gap: config.gap,
          peek: config.peek,
          autoplay: config.autoplay,
          hoverpause: config.hoverpause,
          keyboard: config.keyboard,
          bound: config.bound,
          swipeThreshold: config.swipeThreshold,
          dragThreshold: config.dragThreshold,
          perTouch: config.perTouch,
          touchRatio: config.touchRatio,
          touchAngle: config.touchAngle,
          animationDuration: config.animationDuration,
          rewind: config.rewind,
          rewindDuration: config.rewindDuration,
          animationTimingFunc: config.animationTimingFunc,
          direction: config.direction,
          breakpoints: config.breakpoints,
          throttle: config.throttle,
        });

        // Mount Glide to start the slider.
        glide.mount();
      });
    },
  };
})(Drupal, drupalSettings);
