<?php

namespace Drupal\go_game\Controller;

use Drupal\Core\Controller\ControllerBase;

class PageController extends ControllerBase {
  public function home() {
  $base = \Drupal::request()->getBasePath();
    $build = [
      '#type' => 'container',
      '#attributes' => ['id' => 'go-app'],
      '#attached' => [
        'library' => [
          'go_game/go-ui',
        ],
        'drupalSettings' => [
          'goGame' => [
            'basePath' => $base,
            'gameId' => NULL,
          ],
        ],
      ],
    ];
    return $build;
  }

  public function game(string $id) {
  $base = \Drupal::request()->getBasePath();
    $build = [
      '#type' => 'container',
      '#attributes' => ['id' => 'go-app'],
      '#attached' => [
        'library' => [
          'go_game/go-ui',
        ],
        'drupalSettings' => [
          'goGame' => [
            'basePath' => $base,
            'gameId' => $id,
          ],
        ],
      ],
    ];
    return $build;
  }
}
