# Google PageMap Embed

The Google PageMap Embed module provides a way of adding structured data attributes to your web pages. These attributes
provide Google with information about the data on the page. The PageMaps are indexed by Google and can be used as
filters for search queries.

This module uses a HtmlPreprocessor plugin which embeds the PageMap markup into the 'html_head' of the pages that are
configured to use a PageMap. It also provides a configuration page that allows an administrator to set which content
types should have PageMaps and which fields on those content types should be added as attributes.

For a full description of the module, visit [Google PageMap Embed](https://www.drupal.org/project/google_pagemap).

Submit bug reports and feature requests, or track changes in the
[issue queue](https://www.drupal.org/project/issues/google_pagemap).

## Table of contents

- Requirements
- Installation
- Configuration and Usage
- Maintainers

## Requirements

This module requires the following module:

- [Preprocessor Plugins](https://www.drupal.org/project/preprocessors)

## Installation

Install as you would normally install a contributed Drupal module. For further information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration and Usage

Configuration for the module can be found at the '/admin/config/search/pagemap' route. This configuration page is where
you'll select which content types should have a PageMap embedded and which fields on those content types should have an
associated attribute added to the PageMap. Once you've configured all of your PageMap embeds, you'll need to have your
site re-indexed.

## Maintainers

- Ari Hylas - [ari.saves](https://www.drupal.org/u/arisaves)
- Michael Kinnunen - [mkinnune](https://www.drupal.org/u/mkinnune)
- Sam Lerner - [SameLerner](https://www.drupal.org/u/samlerner)
- Timo Zura - [TimoZura](https://www.drupal.org/u/timozura)
