<?php

namespace Drupal\gotenberg;

use Gotenberg\Gotenberg as GotenbergBase;

use Drupal\Core\Config\ConfigFactoryInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestInterface;

/**
 * @method \Gotenberg\Modules\Chromium chromium
 * @method \Gotenberg\Modules\LibreOffice libreOffice
 * @method \Gotenberg\Modules\PdfEngines pdfEngines
 * @method \Psr\Http\Message\ResponseInterface send(RequestInterface $request, ClientInterface|null $client = null)
 * @method string save(RequestInterface $request, string $dirPath, ClientInterface|null $client = null)
 */
class Gotenberg {

  /**
   * Dimensions of the available paper sizes.
   *
   * @var array
   */
  public const PAPER_SIZES = [
    '4a0' => [66.22, 93.62],
    '2a0' => [46.81, 66.22],
    'a0' => [33.11, 46.81],
    'a1' => [23.39, 33.11],
    'a2' => [16.54, 23.39],
    'a3' => [11.69, 16.54],
    'a4' => [8.27, 11.69],
    'a5' => [5.83, 8.27],
    'a6' => [4.13, 5.83],
    'a7' => [2.91, 4.13],
    'a8' => [2.05, 2.91],
    'a9' => [1.46, 2.05],
    'a10' => [1.02, 1.46],
    'b0' => [39.37, 55.67],
    'b1' => [27.83, 39.37],
    'b2' => [19.68, 27.83],
    'b3' => [13.9, 19.68],
    'b4' => [9.84, 13.9],
    'b5' => [6.93, 9.84],
    'b6' => [4.92, 6.93],
    'b7' => [3.46, 4.92],
    'b8' => [2.44, 3.46],
    'b9' => [1.73, 2.44],
    'b10' => [1.22, 1.73],
    'c0' => [36.1, 51.06],
    'c1' => [25.51, 36.1],
    'c2' => [18.03, 25.51],
    'c3' => [12.76, 18.03],
    'c4' => [9.02, 12.76],
    'c5' => [6.38, 9.02],
    'c6' => [4.49, 6.38],
    'c7' => [3.19, 4.49],
    'c8' => [2.24, 3.19],
    'c9' => [1.57, 2.24],
    'c10' => [1.1, 1.57],
    'ra0' => [33.86, 48.03],
    'ra1' => [24.02, 33.86],
    'ra2' => [16.93, 24.02],
    'ra3' => [12.01, 16.93],
    'ra4' => [8.46, 12.01],
    'sra0' => [35.43, 50.39],
    'sra1' => [25.2, 35.43],
    'sra2' => [17.72, 25.2],
    'sra3' => [12.6, 17.72],
    'sra4' => [8.86, 12.6],
    'letter' => [8.5, 11.0],
    'half-letter' => [5.5, 8.5],
    'legal' => [8.5, 14.0],
    'ledger' => [17.0, 11.0],
    'tabloid' => [11.0, 17.0],
    'executive' => [7.25, 10.5],
    'folio' => [8.5, 13.0],
    'commercial #10 envelope' => [9.5, 4.12],
    'catalog #10 1/2 envelope' => [9.0, 12.0],
    '8.5x11' => [8.5, 11.0],
    '8.5x14' => [8.5, 14.0],
    '11x17' => [11.0, 17.0],
  ];

  /**
   * Constructs the Gotenberg wrapper.
   */
  public function __construct(
    private ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Magic method to call functions in the Gotenberg helper class.
   */
  public function __call(string $name, array $arguments) {
    if (in_array($name, ['chromium', 'libreOffice', 'pdfEngines'])) {
      return GotenbergBase::$name($this->config('base_url'), ...$arguments);
    }

    if (method_exists(GotenbergBase::class, $name)) {
      return GotenbergBase::$name(...$arguments);
    }

    throw new \BadMethodCallException("Method {$name} does not exist.");
  }

  /**
   * Retrieves a config value or object.
   */
  private function config(?string $key = NULL) {
    $config = $this->configFactory->get('gotenberg.settings');
    return $key ? $config->get($key) : $config;
  }

}
