<?php

namespace Drupal\gotenberg\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class GotenbergSettings extends ConfigFormBase {

  /**
   * {@inheritDoc}
   */
  public function getFormId() {
    return 'gotenberg_settings';
  }

  /**
   * {@inheritDoc}
   */
  public function getEditableConfigNames() {
    return ['gotenberg.settings'];
  }

  /**
   * {@inheritDoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['base_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Base URL'),
      '#description' => $this->t("Enter the base URL to your Gotenberg instance, including any ports or sub-paths."),
      '#required' => TRUE,
      '#config_target' => 'gotenberg.settings:base_url',
    ];

    return parent::buildForm($form, $form_state);
  }

}
