/**
 * @file
 * Replaced Drupal cores ajax throbber(s), see: https://www.drupal.org/node/2974681
 * Contains the gov-loading.twig content.
 *
 */
document.addEventListener('DOMContentLoaded', function () {
  // Define a function that Drupal can call to replace the throbber.
  Drupal.theme.ajaxProgressThrobber = function () {
    var loadingText = Drupal.t('Loading…', {}, {
      context: "Loading text for Drupal cores Ajax throbber (fullscreen)"
    });
    return "<div class=\"gov-loading\" loading><div class=\"gov-loading__content\"><div class=\"gov-loading__icon gov-spin-animation gov-icon\"><span class=\"gov-icon__holder\"><svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M18.592 2.8387C20.3273 2.8387 21.7341 4.2391 21.7341 5.96606C21.7341 7.69342 20.3273 9.09402 18.592 9.09402C16.8569 9.09402 15.45 7.69362 15.45 5.96606C15.45 4.2391 16.8569 2.8387 18.592 2.8387ZM21.4392 10.18C20.0255 10.18 18.8788 11.3214 18.8788 12.7284C18.8788 14.1361 20.0255 15.2771 21.4392 15.2775C22.8533 15.2775 24 14.1361 24 12.7284C23.9998 11.3214 22.8533 10.18 21.4392 10.18ZM18.4705 17.5593C17.4832 17.5593 16.6822 18.3566 16.6822 19.3392C16.6822 20.322 17.4832 21.1193 18.4705 21.1193C19.4577 21.1193 20.2586 20.322 20.2586 19.3392C20.2586 18.3566 19.4577 17.5593 18.4705 17.5593ZM11.6305 20.4396C10.6432 20.4396 9.84224 21.2367 9.84224 22.2195C9.84224 23.2027 10.6432 24 11.6305 24C12.6179 24 13.4186 23.2027 13.4186 22.2195C13.4188 21.2367 12.6181 20.4396 11.6305 20.4396ZM4.64083 17.7462C3.71529 17.7462 2.96517 18.4929 2.96517 19.4142C2.96517 20.3351 3.71529 21.0822 4.64083 21.0822C5.56578 21.0822 6.3161 20.3351 6.3161 19.4142C6.3161 18.4931 5.56578 17.7462 4.64083 17.7462ZM1.78475 10.7173C0.79898 10.7173 0 11.5126 0 12.4939C0 13.4745 0.79898 14.2698 1.78475 14.2698C2.76994 14.2698 3.56892 13.4745 3.56892 12.4939C3.56892 11.5126 2.76974 10.7173 1.78475 10.7173ZM4.64083 3.32542C3.39409 3.32542 2.38281 4.33226 2.38281 5.57329C2.38281 6.81431 3.39409 7.82057 4.64083 7.82057C5.88757 7.82057 6.89846 6.81431 6.89846 5.57329C6.89846 4.33226 5.88757 3.32542 4.64083 3.32542ZM11.6435 0C10.1423 0 8.92436 1.21192 8.92436 2.70608C8.92436 4.20042 10.1423 5.41235 11.6435 5.41235C13.1447 5.41235 14.3622 4.20042 14.3622 2.70608C14.3622 1.21192 13.1447 0 11.6435 0Z\" fill=\"currentColor\" /></svg></span></div>" + loadingText + "</div><div class=\"gov-backdrop\"><div role=\"button\" class=\"gov-backdrop__bg\"></div></div></div>";
  };

  Drupal.theme.ajaxProgressIndicatorFullscreen = function () {
    var loadingText = Drupal.t('Loading…', {}, {
      context: "Loading text for Drupal cores Ajax throbber (fullscreen)"
    });
    return "<div class=\"gov-loading\" loading><div class=\"gov-loading__content\"><div class=\"gov-loading__icon gov-spin-animation gov-icon\"><span class=\"gov-icon__holder\"><svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M18.592 2.8387C20.3273 2.8387 21.7341 4.2391 21.7341 5.96606C21.7341 7.69342 20.3273 9.09402 18.592 9.09402C16.8569 9.09402 15.45 7.69362 15.45 5.96606C15.45 4.2391 16.8569 2.8387 18.592 2.8387ZM21.4392 10.18C20.0255 10.18 18.8788 11.3214 18.8788 12.7284C18.8788 14.1361 20.0255 15.2771 21.4392 15.2775C22.8533 15.2775 24 14.1361 24 12.7284C23.9998 11.3214 22.8533 10.18 21.4392 10.18ZM18.4705 17.5593C17.4832 17.5593 16.6822 18.3566 16.6822 19.3392C16.6822 20.322 17.4832 21.1193 18.4705 21.1193C19.4577 21.1193 20.2586 20.322 20.2586 19.3392C20.2586 18.3566 19.4577 17.5593 18.4705 17.5593ZM11.6305 20.4396C10.6432 20.4396 9.84224 21.2367 9.84224 22.2195C9.84224 23.2027 10.6432 24 11.6305 24C12.6179 24 13.4186 23.2027 13.4186 22.2195C13.4188 21.2367 12.6181 20.4396 11.6305 20.4396ZM4.64083 17.7462C3.71529 17.7462 2.96517 18.4929 2.96517 19.4142C2.96517 20.3351 3.71529 21.0822 4.64083 21.0822C5.56578 21.0822 6.3161 20.3351 6.3161 19.4142C6.3161 18.4931 5.56578 17.7462 4.64083 17.7462ZM1.78475 10.7173C0.79898 10.7173 0 11.5126 0 12.4939C0 13.4745 0.79898 14.2698 1.78475 14.2698C2.76994 14.2698 3.56892 13.4745 3.56892 12.4939C3.56892 11.5126 2.76974 10.7173 1.78475 10.7173ZM4.64083 3.32542C3.39409 3.32542 2.38281 4.33226 2.38281 5.57329C2.38281 6.81431 3.39409 7.82057 4.64083 7.82057C5.88757 7.82057 6.89846 6.81431 6.89846 5.57329C6.89846 4.33226 5.88757 3.32542 4.64083 3.32542ZM11.6435 0C10.1423 0 8.92436 1.21192 8.92436 2.70608C8.92436 4.20042 10.1423 5.41235 11.6435 5.41235C13.1447 5.41235 14.3622 4.20042 14.3622 2.70608C14.3622 1.21192 13.1447 0 11.6435 0Z\" fill=\"currentColor\" /></svg></span></div>" + loadingText + "</div><div class=\"gov-backdrop\"><div role=\"button\" class=\"gov-backdrop__bg\"></div></div></div>";
  };
});
