<?php

namespace Drupal\govai;

use GuzzleHttp\Client;

/**
 * GovAI Control API client.
 */
class GovAiControlApi {

  /**
   * The HTTP client.
   */
  protected Client $client;

  /**
   * The base host.
   */
  protected string $baseHost;

  /**
   * GovAiControlApi constructor.
   */
  public function __construct(Client $client) {
    $this->client = $client;
  }

  /**
   * Sets the connection details.
   */
  public function setConnectData(string $baseUrl): void {
    $this->baseHost = $baseUrl;
  }

  /**
   * Returns the list of GovAI models.
   */
  public function getModels(): array {
    $result = json_decode($this->makeRequest('v1/models'), TRUE);
    return $result ?? [];
  }

  /**
   * Execute a GovAI request.
   */
  protected function makeRequest(string $path, array $query_string = [], string $method = 'GET', $body = '', array $options = []) {
    $options['connect_timeout'] = 120;
    $options['read_timeout'] = 120;
    $options['timeout'] = 120;

    if (empty($options['multipart'])) {
      $options['headers']['Content-Type'] = 'application/json';
    }

    if ($body) {
      $options['body'] = json_encode($body);
    }

    $url = rtrim($this->baseHost, '/') . '/' . $path;
    $url .= $query_string ? '?' . http_build_query($query_string) : '';

    $response = $this->client->request($method, $url, $options);
    return $response->getBody();
  }

}
