'use strict';

const gulp = require('gulp');
const sassVariables = require('gulp-sass-variables');
const sass = require('gulp-sass')(require('sass'));
const sourcemaps = require('gulp-sourcemaps');
const yargs = require('yargs/yargs');
const { hideBin } = require('yargs/helpers');

// Parse CLI arguments
const argv = yargs(hideBin(process.argv))
  .options({
    'govuk_compatibility_govukelements': {
      alias: 'ce',
      describe: 'If you’re using or migrating from GOV.UK Elements build with this option',
      type: 'boolean'
    },
    'govuk_compatibility_govuktemplate': {
      alias: 'ct',
      describe: 'If you’re using or migrating from GOV.UK Template build with this option',
      type: 'boolean'
    },
    'govuk_compatibility_govukfrontend': {
      alias: 'cf',
      describe: 'If you’re using or migrating from the old GOV.UK Frontend Toolkit build with this option',
      type: 'boolean'
    },
    'govuk_use_legacy_palette': {
      alias: 'cl',
      describe: 'If you’re not using any of our old frameworks, you can still configure GOV.UK Frontend to use the old colour palette.',
      type: 'boolean'
    }
  })
  .help()
  .argv;

// Drupal theme directory
const themeDir = '.';

// Compile SASS
gulp.task('sass', function () {
  return gulp.src(`${themeDir}/sass/**/*.scss`)
    .pipe(sourcemaps.init())
    .pipe(sassVariables({
      '$govuk-compatibility-govukelements': !!argv.ce,
      '$govuk-compatibility-govuktemplate': !!argv.ct,
      '$govuk-compatibility-govukfrontendtoolkit': !!argv.cf,
      '$govuk-use-legacy-palette': !!argv.cl,
      '$govuk-suppressed-warnings': [
        'legacy-organisation-colours',
        'govuk-typography-scale-14',
        'legacy-colour-param'
      ]
    }))
    .pipe(sass({
      includePaths: ['node_modules'],
      quietDeps: true, // Suppress warnings from dependencies
      silenceDeprecations: ['import', 'legacy-js-api']
    }).on('error', sass.logError))
    .pipe(sourcemaps.write('../map/'))
    .pipe(gulp.dest(`${themeDir}/css`));
});

// Copy GOV.UK Frontend assets
gulp.task('assets', function () {
  return gulp.src(`${themeDir}/node_modules/govuk-frontend/dist/govuk/assets/**/*`, { encoding: false })
    .pipe(gulp.dest(`${themeDir}/assets`));
});

// Watch for changes
gulp.task('watch', function () {
  gulp.watch(`${themeDir}/sass/**/*.scss`, gulp.series('sass'));
});

// Default and build tasks
gulp.task('build', gulp.series('sass', 'assets'));
gulp.task('default', gulp.series('sass', 'assets'));
