<?php

namespace Drupal\graphql_commerce\Plugin\GraphQL\DataProducer;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\Core\Render\RenderContext;
use Drupal\graphql\GraphQL\Execution\FieldContext;
use Drupal\graphql_commerce\Plugin\GraphQL\CommerceCartDataProducerBase;
use Drupal\graphql_commerce\Wrapper\CommerceOrderResponse;

/**
 * Data producer to empty a cart.
 *
 * @DataProducer(
 *   id = "commerce_empty_cart",
 *   name = @Translation("Commerce: Empty Cart"),
 *   description = @Translation("Remove all order items from the cart."),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The mutation response."),
 *   ),
 *   consumes = {
 *     "order" = @ContextDefinition("entity:commerce_order",
 *       label = @Translation("The cart to empty."),
 *     ),
 *   }
 * )
 */
class EmptyCart extends CommerceCartDataProducerBase {

  /**
   * The resolver.
   *
   * @param \Drupal\commerce_order\Entity\Order $order
   *   The cart to empty.
   * @param \Drupal\graphql\GraphQL\Execution\FieldContext $field
   *   The field context.
   *
   * @return \Drupal\graphql_commerce\Wrapper\CommerceOrderResponse
   *   The result.
   */
  public function resolve(OrderInterface $order, FieldContext $field) {
    $context = new RenderContext();
    $this->renderer->executeInRenderContext(
      $context, function () use ($order) {
        $this->cartManager->emptyCart($order);
      }
      );
    $field->addCacheableDependency($context);
    $result = new CommerceOrderResponse($order);
    return $result;
  }

}
