<?php

declare(strict_types=1);

namespace Drupal\graphql_commerce\Plugin\GraphQL\DataProducer;

use Drupal\graphql\GraphQL\Execution\FieldContext;
use Drupal\graphql_commerce\Plugin\GraphQL\CommerceCartDataProducerBase;

/**
 * The get carts data producer.
 *
 * @DataProducer(
 *   id = "commerce_get_carts",
 *   name = @Translation("Commerce: Get Carts"),
 *   description = @Translation("Get the carts."),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("An array of carts."),
 *   ),
 *   consumes = {
 *     "orderType" = @ContextDefinition("string",
 *       label = @Translation("The order bundle."),
 *       required = FALSE,
 *     ),
 *     "storeId" = @ContextDefinition("integer",
 *       label = @Translation("The store id."),
 *       required = FALSE,
 *     ),
 *     "accountId" = @ContextDefinition("integer",
 *       label = @Translation("The user id for which the cart should be created."),
 *       required = FALSE,
 *     ),
 *   }
 * )
 */
class GetCarts extends CommerceCartDataProducerBase {

  /**
   * Resolves all the carts.
   *
   * @param string $orderType
   *   The order bundle.
   * @param int $storeId
   *   The store to create the cart for.
   * @param int $accountId
   *   The user to create the cart for.
   * @param \Drupal\graphql\GraphQL\Execution\FieldContext $field
   *   The field context.
   *
   * @return \Drupal\commerce_order\Entity\OrderInterface[]
   *   The order response.
   */
  public function resolve(?string $orderType = NULL, ?int $storeId = NULL, ?int $accountId = NULL, ?FieldContext $field = NULL): array {
    $values = ['cart' => TRUE];
    if ($orderType) {
      $values['type'] = $orderType;
    }
    if ($storeId) {
      $values['store_id'] = $storeId;
    }
    if ($accountId) {
      $values['uid'] = $accountId;
    }
    return $this->entityTypeManager->getStorage('commerce_order')->loadByProperties($values);
  }

}
