<?php

declare(strict_types=1);

namespace Drupal\graphql_commerce\Resolvers;

use Drupal\commerce_store\Entity\StoreInterface;
use Drupal\commerce_store\Resolver\StoreResolverInterface;
use Drupal\Core\Entity\EntityRepositoryInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * The header resolver.
 */
final class CurrentStoreGraphqlHeaderResolver implements StoreResolverInterface {

  const HEADER = 'Graphql-Commerce-Current-Store';

  /**
   * Constructs a new CurrentStoreGraphqlHeaderResolver object.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $requestStack
   *   The request stack.
   * @param \Drupal\Core\Entity\EntityRepositoryInterface $entityRepository
   *   The entity repository.
   */
  public function __construct(private RequestStack $requestStack, private EntityRepositoryInterface $entityRepository) {
  }

  /**
   * {@inheritdoc}
   */
  public function resolve(): ?StoreInterface {
    $request = $this->requestStack->getCurrentRequest();
    if ($request && $request->headers->has(self::HEADER)) {
      $current_store_uuid = $request->headers->get(self::HEADER);
      $current_store = $this->entityRepository->loadEntityByUuid('commerce_store', $current_store_uuid);
      if ($current_store instanceof StoreInterface) {
        return $current_store;
      }
    }
    return NULL;
  }

}
