<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce\Kernel\DataProducer;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\graphql_commerce\Wrapper\CommerceOrderResponse;
use Drupal\Tests\graphql\Traits\DataProducerExecutionTrait;
use Drupal\Tests\graphql_commerce\Kernel\GraphQLCommerceOrderKernelTestBase;

/**
 * Tests the commerce_empty_cart data producer.
 *
 * @coversDefaultClass \Drupal\graphql_commerce\Plugin\GraphQL\DataProducer\EmptyCart
 * @group graphql_commerce
 */
class EmptyCartTest extends GraphQLCommerceOrderKernelTestBase {

  use DataProducerExecutionTrait;

  /**
   * Tests emptying the cart.
   *
   * @covers ::resolve
   */
  public function testResolveRemoveFromCart(): void {
    $another_variation = $this->createEntity(
      'commerce_product_variation', [
        'type' => 'default',
        'sku' => $this->randomMachineName(),
        'price' => [
          'number' => 259,
          'currency_code' => 'USD',
        ],
        'title' => 'Some temporary title',
        'product_id' => $this->product->id(),
      ]
    );

    $cart = $this->cartProvider->createCart('default');
    $this->cartManager->addEntity($cart, $this->variation, 2);
    $this->cartManager->addEntity($cart, $another_variation, 3);
    $this->assertEquals(2, count($cart->getItems()));

    $response = $this->resolveEmptyCart($cart);
    $this->assertNotEmpty($response->getOrder());
    $this->assertEmpty($response->getOrder()->getItems());
  }

  /**
   * Execute the empty cart data producer.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The cart to empty.
   *
   * @return \Drupal\graphql_commerce\Wrapper\CommerceOrderResponse
   *   The response of the mutation operation.
   */
  private function resolveEmptyCart(OrderInterface $order): CommerceOrderResponse {
    return $this->executeDataProducer(
      'commerce_empty_cart', [
        'order' => $order,
      ]
    );
  }

}
