<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce\Kernel\DataProducer;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\Tests\graphql\Traits\DataProducerExecutionTrait;
use Drupal\Tests\graphql_commerce\Kernel\GraphQLCommerceOrderKernelTestBase;

/**
 * Tests the order total summary data producer.
 *
 * @coversDefaultClass \Drupal\graphql_commerce\Plugin\GraphQL\DataProducer\OrderTotalSummary
 * @group graphql_commerce
 */
class OrderTotalSummaryTest extends GraphQLCommerceOrderKernelTestBase {

  use DataProducerExecutionTrait;

  /**
   * Tests the order total summary data producer.
   *
   * @covers ::resolve
   */
  public function testOrderTotalSummaryDataProducer(): void {
    $cart = $this->cartProvider->createCart('default');
    $this->cartManager->addEntity($cart, $this->variation, 2);

    $response = $this->resolveOrderTotalSummary($cart);
    /** @var \Drupal\commerce_price\Price $subtotal */
    $subtotal = $response['subtotal'];
    /** @var \Drupal\commerce_price\Price $total */
    $total = $response['total'];
    $this->assertEquals('1998.00', $subtotal->getNumber());
    $this->assertEquals('1998.00', $total->getNumber());
    $this->assertEquals($cart->id(), $response['order']->id());
  }

  /**
   * Execute the order total summary data producer.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order.
   *
   * @return \Drupal\graphql_commerce\Wrapper\CommerceOrderResponse
   *   The order response.
   */
  private function resolveOrderTotalSummary(OrderInterface $order) {
    return $this->executeDataProducer(
      'commerce_order_total_summary', [
        'order' => $order,
      ]
    );
  }

}
