<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce\Kernel\SchemaExtension;

use Drupal\graphql\Entity\ServerInterface;
use Drupal\Tests\graphql_commerce\Kernel\GraphQLCommerceOrderKernelTestBase;
use GraphQL\Server\OperationParams;

/**
 * Tests the commerce_order_total_summary extension.
 *
 * @group graphql_core_schema
 */
class OrderTotalSummaryExtensionTest extends GraphQLCommerceOrderKernelTestBase {

  /**
   * The GraphQL server.
   */
  protected ServerInterface $server;

  /**
   * Test the order total summary schema extension.
   */
  public function testOrderTotalSummaryExtension(): void {
    $this->server = $this
      ->getCoreComposableServerBuilder()
      ->enableValueFields()
      ->enableExtension('commerce')
      ->enableExtension('entity_query')
      ->enableEntityType('commerce_order', ['id'], ['default'])
      ->enableEntityType('commerce_product_variation')
      ->enableEntityType('user', ['uid'])
      ->createServer();

    $cart = $this->cartProvider->createCart('default');
    $this->cartManager->addEntity($cart, $this->variation, 2);

    $variables = [
      'order' => $cart->id(),
    ];
    $expected = [
      'id' => $cart->id(),
      'orderTotalSummary' => [
        'subTotalToString' => '1998 USD',
        'totalToString' => '1998 USD',
      ],
    ];
    $this->assertOrderTotalSummary($variables, $expected);
  }

  /**
   * Assert order total summary.
   *
   * @param array $variables
   *   The variables to pass to the query.
   * @param array $expected
   *   The expected values.
   */
  private function assertOrderTotalSummary(array $variables, array $expected) {
    $query = <<<GQL
      query OrderTotalSummary(\$order: ID!) {
        entityById(entityType: COMMERCE_ORDER, id: \$order) {
          ... on CommerceOrderDefault {
            id
            orderTotalSummary {
              subTotalToString
              totalToString
            }
          }
        }
      }
    GQL;

    $params = OperationParams::create(
      [
        'query' => $query,
        'variables' => $variables,
      ]
    );
    $result = $this->server->executeOperation($params);
    $data = $result->data['entityById'];
    $this->assertEquals($data, $expected);
  }

}
