<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce\Unit\Resolver;

use Drupal\graphql_commerce\Resolvers\CurrentStoreGraphqlHeaderResolver;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\graphql_commerce\Resolver\CurrentStoreGraphqlHeaderResolver
 * @group              graphql_commerce
 */
class CurrentStoreGraphqlHeaderResolverTest extends UnitTestCase {

  /**
   * The resolver.
   *
   * @var \Drupal\graphql_commerce\Resolvers\CurrentStoreGraphqlHeaderResolver
   */
  protected $resolver;

  const STORE_UUID = 'store_uuid';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $request = $this->getMockBuilder('\Symfony\Component\HttpFoundation\Request')
      ->disableOriginalConstructor()
      ->getMock();
    $request->headers = $this->getMockBuilder('Symfony\Component\HttpFoundation\HeaderBag')
      ->disableOriginalConstructor()
      ->getMock();
    $request->headers->expects($this->once())
      ->method('has')
      ->with(CurrentStoreGraphqlHeaderResolver::HEADER)
      ->willReturn(TRUE);

    $request->headers->expects($this->once())
      ->method('get')
      ->with(CurrentStoreGraphqlHeaderResolver::HEADER)
      ->willReturn(self::STORE_UUID);

    $request_stack = $this->getMockBuilder('\Symfony\Component\HttpFoundation\RequestStack')
      ->disableOriginalConstructor()
      ->getMock();
    $request_stack->expects($this->once())
      ->method('getCurrentRequest')
      ->willReturn($request);

    $store = $this->getMockBuilder('\Drupal\commerce_store\Entity\Store')
      ->disableOriginalConstructor()
      ->getMock();
    $store->expects($this->once())
      ->method('uuid')
      ->willReturn(self::STORE_UUID);

    $entity_repository = $this->getMockBuilder('\Drupal\Core\Entity\EntityRepository')
      ->disableOriginalConstructor()
      ->getMock();
    $entity_repository->expects($this->once())
      ->method('loadEntityByUuid')
      ->with('commerce_store', self::STORE_UUID)
      ->willReturn($store);

    $this->resolver = new CurrentStoreGraphqlHeaderResolver($request_stack, $entity_repository);
  }

  /**
   * @covers ::resolve
   */
  public function testResolve() {
    $this->assertEquals(self::STORE_UUID, $this->resolver->resolve()->uuid());
  }

}
