<?php

namespace Drupal\graphql_commerce_promotion\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\graphql_core_schema\TypeAwareSchemaExtensionInterface;

/**
 * The commerce_promotion schema extension.
 *
 * @SchemaExtension(
 *   id = "commerce_promotion",
 *   name = "Commerce Promotion",
 *   description = "Integration for commerce_promotion.",
 *   schema = "core_composable"
 * )
 */
class PromotionExtension extends SdlSchemaExtensionPluginBase implements TypeAwareSchemaExtensionInterface {

  /**
   * {@inheritdoc}
   */
  public function getEntityTypeDependencies() {
    return ['commerce_promotion', 'commerce_promotion_coupon'];
  }

  /**
   * {@inheritdoc}
   */
  public function getExtensionDependencies() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getTypeExtensionDefinition(array $types) {
  }

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver(
      'Mutation', 'commerceApplyCoupon',
      $builder->produce('commerce_promotion_apply_coupon')
        ->map('couponCode', $builder->fromArgument('couponCode'))
        ->map('order', $builder->produce('entity_load')
          ->map('type', $builder->fromValue('commerce_order'))
          ->map('access', $builder->fromValue(FALSE))
          ->map('id', $builder->fromArgument('order'))
        )
    );

    $registry->addFieldResolver(
      'Mutation', 'commerceRemoveCoupon',
      $builder->produce('commerce_promotion_remove_coupon')
        ->map('couponCode', $builder->fromArgument('couponCode'))
        ->map('order', $builder->produce('entity_load')
          ->map('type', $builder->fromValue('commerce_order'))
          ->map('access', $builder->fromValue(FALSE))
          ->map('id', $builder->fromArgument('order'))
        )
    );
  }

}
