<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce_promotion\Kernel;

use Drupal\Tests\graphql\Traits\DataProducerExecutionTrait;
use Drupal\Tests\graphql_commerce\Kernel\GraphQLCommerceOrderKernelTestBase;

/**
 * Base class for testing coupon data producers.
 */
abstract class CouponTestBase extends GraphQLCommerceOrderKernelTestBase {

  use DataProducerExecutionTrait;

  /**
   * A coupon.
   *
   * @var \Drupal\commerce_promotion\Entity\CouponInterface
   */
  protected $coupon;

  /**
   * A promotion.
   *
   * @var \Drupal\commerce_promotion\Entity\PromotionInterface
   */
  protected $promotion;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_promotion',
    'graphql_commerce_promotion',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('commerce_promotion_coupon');
    $this->installEntitySchema('commerce_promotion');

    // Starts now, enabled. No end time.
    $this->promotion = $this->createEntity(
      'commerce_promotion', [
        'name' => 'Promotion (with coupon)',
        'order_types' => ['default'],
        'stores' => [$this->store->id()],
        'status' => TRUE,
        'offer' => [
          'target_plugin_id' => 'order_fixed_amount_off',
          'target_plugin_configuration' => [
            'amount' => [
              'number' => '25.00',
              'currency_code' => 'USD',
            ],
          ],
        ],
        'start_date' => '2017-01-01',
        'conditions' => [],
      ]
    );

    $this->coupon = $this->createEntity(
      'commerce_promotion_coupon', [
        'code' => $this->getRandomGenerator()->word(8),
        'status' => TRUE,
      ]
    );
    $this->coupon->save();
    $this->promotion->addCoupon($this->coupon);
    $this->promotion->save();
  }

}
