<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce_promotion\Kernel\DataProducer;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\graphql_commerce\Wrapper\CommerceOrderResponse;
use Drupal\Tests\graphql_commerce_promotion\Kernel\CouponTestBase;

/**
 * Tests the coupon data producers.
 *
 * @coversClass \Drupal\graphql_commerce_promotion\Plugin\GraphQL\DataProducer\ApplyCoupon
 * @coversClass \Drupal\graphql_commerce_promotion\Plugin\GraphQL\DataProducer\RemoveCoupon
 * @group graphql_commerce
 */
class CouponTest extends CouponTestBase {

  /**
   * Tests applying and removing a coupon.
   *
   * @covers ::resolve
   */
  public function testResolveApplyCoupon(): void {
    $cart = $this->cartProvider->createCart('default');
    $this->cartManager->addEntity($cart, $this->variation, 1);

    $this->resolveApplyCoupon($cart, $this->coupon->getCode());

    /** @var \Drupal\commerce_order\Entity\OrderInterface $cart */
    $cart = $this->container->get('entity_type.manager')->getStorage('commerce_order')->load($cart->id());
    $price = $cart->getTotalPrice();
    $this->assertEquals($price->getNumber(), 974);

    $this->resolveRemoveCoupon($cart, $this->coupon->getCode());
    $cart = $this->container->get('entity_type.manager')->getStorage('commerce_order')->load($cart->id());
    $price = $cart->getTotalPrice();
    $this->assertEquals($price->getNumber(), $this->variation->getPrice()->getNumber());
  }

  /**
   * Execute the apply coupon data producer.
   */
  private function resolveApplyCoupon(OrderInterface $cart, string $couponCode): CommerceOrderResponse {
    return $this->executeDataProducer(
      'commerce_promotion_apply_coupon', [
        'order' => $cart,
        'couponCode' => $couponCode,
      ]
    );
  }

  /**
   * Execute the remove coupon data producer.
   */
  private function resolveRemoveCoupon(OrderInterface $cart, string $couponCode): CommerceOrderResponse {
    return $this->executeDataProducer(
      'commerce_promotion_remove_coupon', [
        'order' => $cart,
        'couponCode' => $couponCode,
      ]
    );
  }

}
