<?php

namespace Drupal\graphql_commerce\Plugin\GraphQL\SchemaExtension;

use Drupal\commerce_order\AvailabilityResult;
use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;

/**
 * The commerce schema extension.
 *
 * @SchemaExtension(
 *   id = "commerce_availability",
 *   name = "Commerce Variation Availability",
 *   description = "Provides integration of computed variation availability.",
 *   schema = "core_composable"
 * )
 */
class ComputedAvailabilityExtension extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function getEntityTypeDependencies() {
    return ['commerce_product_variation'];
  }

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver(
      'CommerceProductVariation', 'computedAvailability',
      $builder->produce('commerce_computed_availability')
        ->map('productVariation', $builder->fromParent())
        ->map('quantity', $builder->fromArgument('quantity'))
    );

    $registry->addFieldResolver(
      'CommerceAvailabilityResult',
      'reason',
      $builder->callback(
        function (AvailabilityResult $value) {
          return $value->getReason();
        }
      )
    );

    $registry->addFieldResolver(
      'CommerceAvailabilityResult',
      'code',
      $builder->callback(
        function (AvailabilityResult $value) {
          return $value->getCode();
        }
      )
    );

    $registry->addFieldResolver(
      'CommerceAvailabilityResult',
      'isNeutral',
      $builder->callback(
        function (AvailabilityResult $value) {
          return $value->isNeutral();
        }
      )
    );

    $registry->addFieldResolver(
      'CommerceAvailabilityResult',
      'isUnavailable',
      $builder->callback(
        function (AvailabilityResult $value) {
          return $value->isUnavailable();
        }
      )
    );
  }

}
