<?php

namespace Drupal\graphql_commerce\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;

/**
 * The commerce attribute schema extension.
 *
 * @SchemaExtension(
 *   id = "commerce_attribute",
 *   name = "Commerce Attribute",
 *   description = "Improved support for product attributes.",
 *   schema = "core_composable"
 * )
 */
class ProductAttributeExtension extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function getEntityTypeDependencies() {
    return [
      'commerce_product_variation',
      'commerce_product_attribute',
      'commerce_product_attribute_value',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getExtensionDependencies() {
    return ['commerce'];
  }

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver(
      'CommerceProductVariation', 'attributes',
      $builder->produce('commerce_product_attributes')->map('variation', $builder->fromParent())
    );

    $registry->addFieldResolver(
      'CommercePreparedAttribute', 'elementType',
      $builder->callback(
        function (array $attribute) {
          return $attribute['element_type'];
        }
      )
    );

    $registry->addFieldResolver(
      'CommercePreparedAttribute', 'values',
      $builder
        ->produce('commerce_prepared_attribute_values')
        ->map('preparedAttribute', $builder->fromParent())
    );

    $registry->addFieldResolver(
      'CommercePreparedAttributeValue', 'id',
      $builder->callback(
        function (array $values) {
          return $values['id'] ?? NULL;
        }
      )
    );

    $registry->addFieldResolver(
      'CommercePreparedAttributeValue', 'label',
      $builder->callback(
        function (array $values) {
          return $values['label'] ?? NULL;
        }
      )
    );
  }

}
