<?php

declare(strict_types=1);

namespace Drupal\graphql_commerce\Wrapper;

use Drupal\commerce_order\Entity\OrderInterface;
use Drupal\graphql\GraphQL\Response\Response;

/**
 * Helper class that contains commerce order results.
 */
class CommerceOrderResponse extends Response {

  /**
   * Constructs a new CommerceOrderResponse object.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface|null $order
   *   The order.
   */
  public function __construct(protected ?OrderInterface $order = NULL) {
  }

  /**
   * Get the order.
   *
   * @return \Drupal\commerce_order\Entity\Order|null
   *   The order.
   */
  public function getOrder(): ?OrderInterface {
    return $this->order;
  }

  /**
   * Set the order.
   *
   * @param \Drupal\commerce_order\Entity\Order $order
   *   The order.
   *
   * @return self
   *   The order response.
   */
  public function setOrder(OrderInterface $order): self {
    $this->order = $order;
    return $this;
  }

}
