<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce\Kernel\DataProducer;

use Drupal\commerce_product\Entity\ProductVariation;
use Drupal\commerce_product\Entity\ProductVariationInterface;
use Drupal\Tests\graphql_commerce\Kernel\ProductAttributesTestBase;

/**
 * Tests some product attributes data producers.
 *
 * @coversDefaultClass \Drupal\graphql_commerce\Plugin\GraphQL\DataProducer\ProductAttributes
 * @group graphql_commerce
 */
class ProductAttributesTest extends ProductAttributesTestBase {

  /**
   * Tests product attributes.
   *
   * @covers ::resolve
   */
  public function testProductAttributes(): void {
    $this->variation = $this->entityTypeManager->getStorage('commerce_product_variation')->load($this->variation->id());
    $this->variation->set('attribute_color', $this->colorAttributes['blue']->id(),);
    $this->variation->save();

    $another_variation = ProductVariation::create([
      'type' => 'default',
      'sku' => strtolower($this->randomMachineName()),
      'price' => [
        'number' => 100,
        'currency_code' => 'USD',
      ],
      'attribute_color' => $this->colorAttributes['black']->id(),
      'product_id' => $this->product->id(),
    ]);
    $another_variation->save();

    $this->product = $this->entityTypeManager->getStorage('commerce_product')->load($this->product->id());

    $response = $this->resolveAttributes($this->variation);
    $this->assertEquals('color', $response[0]['id']);
    // 'values' stores all selectable attribute values.
    $this->assertEquals([2 => 'Blue', 1 => 'Black'], $response[0]['values']);

    $response = $this->resolveAttributes($another_variation);
    $this->assertEquals('color', $response[0]['id']);
    $this->assertEquals([2 => 'Blue', 1 => 'Black'], $response[0]['values']);
  }

  /**
   * Execute the product attributes data producer.
   *
   * @param \Drupal\commerce_product\Entity\ProductVariationInterface $productVariation
   *   The product variation.
   */
  private function resolveAttributes(ProductVariationInterface $productVariation) {
    return $this->executeDataProducer(
      'commerce_product_attributes', [
        'variation' => $productVariation,
      ]
    );
  }

}
