<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_commerce\Kernel\DataProducer;

use Drupal\commerce_order\Entity\OrderItemInterface;
use Drupal\graphql_commerce\Wrapper\CommerceOrderResponse;
use Drupal\Tests\graphql\Traits\DataProducerExecutionTrait;
use Drupal\Tests\graphql_commerce\Kernel\GraphQLCommerceOrderKernelTestBase;

/**
 * Tests the commerce_remove_from_cart data producer.
 *
 * @coversDefaultClass \Drupal\graphql_commerce\Plugin\GraphQL\DataProducer\RemoveFromCart
 * @group graphql_commerce
 */
class RemoveFromCartTest extends GraphQLCommerceOrderKernelTestBase {

  use DataProducerExecutionTrait;

  /**
   * Tests removing item from the cart.
   *
   * @covers ::resolve
   */
  public function testResolveRemoveFromCart(): void {
    $cart = $this->cartProvider->createCart('default');
    $item = $this->cartManager->addEntity($cart, $this->variation, 2);
    $this->assertEquals(1, count($cart->getItems()));

    $response = $this->resolveRemoveFromCart($item);
    $this->assertNotEmpty($response->getOrder());
    $this->assertEmpty($response->getOrder()->getItems());
  }

  /**
   * Execute the remove from cart data producer.
   *
   * Resolves the given order item ID and removes it from the order.
   *
   * @param \Drupal\commerce_order\Entity\OrderItemInterface $item
   *   The order object for which to remove the order item.
   *
   * @return \Drupal\graphql_commerce\Wrapper\CommerceOrderResponse
   *   The response of the mutation operation.
   */
  private function resolveRemoveFromCart(OrderItemInterface $item): CommerceOrderResponse {
    return $this->executeDataProducer(
      'commerce_remove_from_cart', [
        'item' => $item,
      ]
    );
  }

}
