<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_edges\Plugin\GraphQL\DataProducer;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\DataProducer;
use Drupal\graphql\Plugin\DataProducerPluginCachingInterface;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\graphql_compose_edges\Wrappers\EdgeInterface;

/**
 * Returns the cursor for an edge.
 */
#[DataProducer(
  id: "edge_cursor",
  name: new TranslatableMarkup("Edge cursor"),
  description: new TranslatableMarkup("Returns the cursor of an edge."),
  produces: new ContextDefinition(
    data_type: "string",
    label: new TranslatableMarkup("Cursor"),
  ),
  consumes: [
    "edge" => new ContextDefinition(
      data_type: "any",
      label: new TranslatableMarkup("EdgeInterface"),
    ),
  ],
)]
class EdgeCursor extends DataProducerPluginBase implements DataProducerPluginCachingInterface {

  /**
   * Resolves the value for this data producer.
   *
   * @param \Drupal\graphql_compose_edges\Wrappers\EdgeInterface $edge
   *   The edge to return the cursor for.
   *
   * @return mixed
   *   The cursor for this edge.
   */
  public function resolve(EdgeInterface $edge) {
    return $edge->getCursor();
  }

}
