<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_edges\Plugin\GraphQL\DataProducer;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\DataProducer;
use Drupal\graphql\Plugin\DataProducerPluginCachingInterface;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\graphql_compose_edges\Wrappers\EdgeInterface;

/**
 * Returns the node for an edge.
 */
#[DataProducer(
  id: "edge_node",
  name: new TranslatableMarkup("Edge node"),
  description: new TranslatableMarkup("Returns the node associated with an edge."),
  produces: new ContextDefinition(
    data_type: "any",
    label: new TranslatableMarkup("EdgeNode"),
  ),
  consumes: [
    "edge" => new ContextDefinition(
      data_type: "any",
      label: new TranslatableMarkup("EdgeInterface"),
    ),
  ],
)]
class EdgeNode extends DataProducerPluginBase implements DataProducerPluginCachingInterface {

  /**
   * Resolves the value.
   *
   * @param \Drupal\graphql_compose_edges\Wrappers\EdgeInterface $edge
   *   The edge to retrieve the node from.
   *
   * @return mixed
   *   The graph node.
   */
  public function resolve(EdgeInterface $edge) {
    return $edge->getNode();
  }

}
