<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_image_style\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Attribute\SchemaType;
use Drupal\graphql_compose\Utility\ComposeConfig;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use Drupal\image\ImageStyleInterface;
use GraphQL\Type\Definition\EnumType;

use function Symfony\Component\String\u;

/**
 * {@inheritdoc}
 */
#[SchemaType(
  id: "ImageStyleAvailable",
)]
class ImageStyleAvailable extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getTypes(): array {
    $types = [];

    $settings = ComposeConfig::config();

    $image_styles = array_filter(
      $this->entityTypeManager->getStorage('image_style')->loadMultiple(),
      fn (ImageStyleInterface $style) => $settings->get('entity_config.image_style.' . $style->id() . '.enabled') ?: FALSE
    );

    $values = [];
    foreach ($image_styles as $image_style) {

      $id = u($image_style->id())
        ->snake()
        ->upper()
        ->replaceMatches('/[^A-Z0-9_]/', '_')
        ->replaceMatches('/^([0-9]+)$/', 'STYLE_$1')
        ->toString();

      $values[$id] = [
        'value' => $image_style->id(),
        'description' => (string) $image_style->label(),
      ];
    }

    $undefined = [
      'UNDEFINED' => [
        'value' => 'undefined',
        'description' => (string) $this->t('No image styles have been enabled.'),
      ],
    ];

    $types[] = new EnumType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('List of image styles available to use.'),
      'values' => $values ?: $undefined,
    ]);

    return $types;
  }

}
