<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_layout_paragraphs\Plugin\GraphQL\SchemaExtension;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\SchemaExtension;
use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql_compose\Plugin\GraphQL\SchemaExtension\ResolverOnlySchemaExtensionPluginBase;

/**
 * Add layout paragraphs to the Schema.
 */
#[SchemaExtension(
  id: "graphql_compose_layout_paragraphs",
  name: new TranslatableMarkup("GraphQL Compose Layout Paragraphs"),
  description: new TranslatableMarkup("Layout entities"),
  schema: "graphql_compose",
  priority: 0,
)]
class LayoutParagraphsSchemaExtension extends ResolverOnlySchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();
    $paragraph_plugin = $this->gqlEntityTypeManager->getPluginInstance('paragraph');

    foreach ($paragraph_plugin->getBundles() as $bundle) {
      $registry->addFieldResolver(
        $bundle->getTypeSdl(),
        'composition',
        $builder->produce('layout_paragraphs')
          ->map('entity', $builder->fromParent())
      );
    }
  }

}
