<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_metatags\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Attribute\SchemaType;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\UnionType;

/**
 * {@inheritdoc}
 */
#[SchemaType(
  id: "MetaTagUnion",
)]
class MetaTagUnion extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getTypes(): array {
    $types = [];

    $types[] = new UnionType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('A meta tag element.'),
      'types' => fn() => [
        static::type('MetaTagLink'),
        static::type('MetaTagValue'),
        static::type('MetaTagProperty'),
        static::type('MetaTagScript'),
      ],
    ]);

    return $types;
  }

}
