<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_users\Plugin\GraphQL\DataProducer;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\DataProducer;
use Drupal\graphql\Plugin\DataProducerPluginCachingInterface;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\user\UserInterface;

/**
 * Returns the roles for a user.
 */
#[DataProducer(
  id: "user_roles",
  name: new TranslatableMarkup("User roles"),
  description: new TranslatableMarkup("Returns the roles that a user has."),
  produces: new ContextDefinition(
    data_type: "array",
    label: new TranslatableMarkup("User roles"),
  ),
  consumes: [
    "user" => new ContextDefinition(
      data_type: "entity:user",
      label: new TranslatableMarkup("User"),
    ),
  ],
)]
class UserRoles extends DataProducerPluginBase implements DataProducerPluginCachingInterface {

  /**
   * Resolves the value for this data producer.
   *
   * @param \Drupal\user\UserInterface $user
   *   The user to get the roles for.
   *
   * @return string[]
   *   The roles the user has.
   */
  public function resolve(UserInterface $user): array {
    return $user->getRoles();
  }

}
