<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attribute for entity type plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class EntityType extends Plugin {

  /**
   * Constructs a new entity type plugin.
   *
   * @param string $id
   *   The machine name of the entity type. eg node.
   * @param string[] $interfaces
   *   (optional) The interfaces implemented by the entity type.
   * @param array $base_fields
   *   (optional) The base fields provided by the entity type.
   * @param bool $hidden
   *   (optional) Whether the entity type is hidden from the UI.
   * @param string|null $type_sdl
   *   (optional) Use this as a type name instead of the id.
   * @param string|null $prefix
   *   (optional) The prefix to use for the entity type bundles.
   * @param class-string|null $deriver
   *   (optional) The deriver class for the entity type.
   * @param array $third_party_settings
   *   (optional) Third party settings.
   */
  public function __construct(
    public readonly string $id,
    public readonly array $interfaces = [],
    public readonly array $base_fields = [],
    public readonly bool $hidden = FALSE,
    public readonly ?string $type_sdl = NULL,
    public readonly ?string $prefix = NULL,
    public readonly ?string $deriver = NULL,
    public readonly array $third_party_settings = [],
  ) {}

}
