<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQL\SchemaExtension;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\SchemaExtension;
use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;

/**
 * Adds Schema Types defined by the GraphQL Compose plugin system.
 *
 * @internal
 */
#[SchemaExtension(
  id: "graphql_compose_entity",
  name: new TranslatableMarkup("GraphQL Compose Entities"),
  description: new TranslatableMarkup("GraphQL types defined by plugins."),
  schema: "graphql_compose",
  priority: 100,
)]
class EntitySchemaExtension extends ResolverOnlySchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    // Resolve entity types and fields.
    foreach ($this->gqlEntityTypeManager->getPluginInstances() as $entity_type_plugin) {
      $entity_type_plugin->registerResolvers($registry, $builder);
    }

    // Utility for junk.
    $registry->addFieldResolver(
      'UnsupportedType',
      'unsupported',
      $builder->callback(fn () => TRUE),
    );
  }

}
