<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\EntityType;

use Drupal\graphql_compose\Attribute\EntityType;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeEntityTypeBase;

/**
 * {@inheritdoc}
 *
 * This is a bit of an odd-ball entity, sometimes in Drupal we get
 * Language entities that won't work with all our entity resolvers.
 * Sometimes we get back this ConfigurableLanguage entity type.
 *
 * LanguageSchemaExtension deals with resolution of LanguageInterface methods.
 *
 * This resolves an issue of people creating fields on a node that
 * use a language as an entity reference, whilst maintaining a consistent
 * type in the schema.
 */
#[EntityType(
  id: "configurable_language",
  prefix: "",
  type_sdl: "Language",
  hidden: TRUE,
  base_fields: [
    "name" => [
      "field_type" => "entity_label",
    ],
    "direction" => [],
    "weight" => [],
  ],
)]
class ConfigurableLanguage extends GraphQLComposeEntityTypeBase {

}
