<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\FieldType;

use Drupal\graphql_compose\Attribute\FieldType;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\graphql\GraphQL\Execution\FieldContext;
use Drupal\graphql_compose\Plugin\GraphQL\DataProducer\FieldProducerItemInterface;
use Drupal\graphql_compose\Plugin\GraphQL\DataProducer\FieldProducerTrait;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeFieldTypeBase;

/**
 * {@inheritdoc}
 */
#[FieldType(
  id: "geomap",
  type_sdl: "Geomap",
)]
class GeomapItem extends GraphQLComposeFieldTypeBase implements FieldProducerItemInterface {

  use FieldProducerTrait;

  /**
   * {@inheritdoc}
   */
  public function resolveFieldItem(FieldItemInterface $item, FieldContext $context) {

    return [
      'addressName' => $item->address_name ?: NULL,
      'street' => $item->street ?: NULL,
      'zipcode' => $item->zipcode ?: NULL,
      'city' => $item->city ?: NULL,
      'country' => $item->country ?: NULL,
      'additional' => $item->additional ?: NULL,
      'lat' => $item->lat ?: NULL,
      'lon' => $item->lon ?: NULL,
      'feature' => $item->feature ?: NULL,
    ];
  }

}
