<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_edges\Plugin\GraphQL\DataProducer;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\DataProducer;
use Drupal\graphql\Plugin\DataProducerPluginCachingInterface;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\graphql_compose_edges\ConnectionInterface;

/**
 * Produces the page info from a connection object.
 */
#[DataProducer(
  id: "connection_page_info",
  name: new TranslatableMarkup("Connection page info"),
  description: new TranslatableMarkup("Returns the page info of a connection."),
  produces: new ContextDefinition(
    data_type: "page_info",
    label: new TranslatableMarkup("Page Info"),
  ),
  consumes: [
    "connection" => new ContextDefinition(
      data_type: "any",
      label: new TranslatableMarkup("Query Connection"),
    ),
  ],
)]
class ConnectionPageInfo extends DataProducerPluginBase implements DataProducerPluginCachingInterface {

  /**
   * Resolves the request.
   *
   * @param \Drupal\graphql_compose_edges\ConnectionInterface $connection
   *   The connection to return the page info for.
   *
   * @return mixed
   *   The page info for the connection.
   */
  public function resolve(ConnectionInterface $connection) {
    return $connection->pageInfo();
  }

}
