<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_layouts\Plugin\GraphQL\DataProducer;

use Drupal\Core\Layout\LayoutDefinition;
use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\DataProducer;
use Drupal\graphql\Plugin\DataProducerPluginCachingInterface;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;

/**
 * Load drupal layout definition property.
 */
#[DataProducer(
  id: "layout_definition_property",
  name: new TranslatableMarkup("Layout Definition property"),
  description: new TranslatableMarkup("Layout Definition property by key."),
  produces: new ContextDefinition(
    data_type: "any",
    label: new TranslatableMarkup("Value of property"),
  ),
  consumes: [
    "entity" => new ContextDefinition(
      data_type: "any",
      label: new TranslatableMarkup("Layout Definition"),
    ),
    "path" => new ContextDefinition(
      data_type: "any",
      label: new TranslatableMarkup("Property"),
    ),
  ],
)]
class LayoutDefinitionProperty extends DataProducerPluginBase implements DataProducerPluginCachingInterface {

  /**
   * Resolve the layout definition.
   *
   * @param \Drupal\Core\Layout\LayoutDefinition $layout
   *   The layout definition.
   * @param string $path
   *   The property path.
   *
   * @return mixed
   *   The value of the property.
   */
  public function resolve(LayoutDefinition $layout, string $path): mixed {
    return ($path === 'regions') ? $layout->getRegionNames() : $layout->get($path);
  }

}
