<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_menus\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Attribute\SchemaType;
use Drupal\graphql_compose\Utility\ComposeConfig;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use Drupal\system\MenuInterface;
use GraphQL\Type\Definition\EnumType;

use function Symfony\Component\String\u;

/**
 * {@inheritdoc}
 */
#[SchemaType(
  id: "MenuAvailable",
)]
class MenuAvailable extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getTypes(): array {
    $types = [];

    $settings = ComposeConfig::config();

    $menus = array_filter(
      $this->entityTypeManager->getStorage('menu')->loadMultiple(),
      fn (MenuInterface $menu) => $settings->get('entity_config.menu.' . $menu->id() . '.enabled') ?: FALSE
    );

    $values = [];
    foreach ($menus as $menu) {
      $id = u($menu->id())
        ->snake()
        ->upper()
        ->replaceMatches('/^([0-9]+)$/', 'MENU_$1')
        ->replaceMatches('/[^A-Z0-9_]/', '_')
        ->toString();

      $values[$id] = [
        'value' => $menu->id(),
        'description' => (string) $menu->label(),
      ];
    }

    $undefined = [
      'UNDEFINED' => [
        'value' => 'undefined',
        'description' => (string) $this->t('No menus have been enabled.'),
      ],
    ];

    $types[] = new EnumType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('List of menus available to load.'),
      'values' => $values ?: $undefined,
    ]);

    return $types;
  }

}
