<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_users\Plugin\GraphQL\DataProducer;

use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\Plugin\Context\EntityContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\graphql\Attribute\DataProducer;
use Drupal\graphql\Plugin\DataProducerPluginCachingInterface;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\user\UserInterface;

/**
 * Returns the status for a user.
 */
#[DataProducer(
  id: "user_status",
  name: new TranslatableMarkup("User status"),
  description: new TranslatableMarkup("Returns the status of the user."),
  produces: new ContextDefinition(
    data_type: "string",
    label: new TranslatableMarkup("User status"),
  ),
  consumes: [
    "user" => new EntityContextDefinition(
      data_type: "entity:user",
      label: new TranslatableMarkup("User"),
    ),
  ],
)]
class UserStatus extends DataProducerPluginBase implements DataProducerPluginCachingInterface {

  /**
   * Resolves the value for this data producer.
   *
   * @param \Drupal\user\UserInterface $user
   *   The user to get the status from.
   *
   * @return string
   *   The status of the user ("ACTIVE" or "BLOCKED").
   */
  public function resolve(UserInterface $user): string {
    return $user->isActive() ? 'ACTIVE' : 'BLOCKED';
  }

}
