<?php

namespace Drupal\graphql_compose\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\graphql\Entity\ServerInterface;

/**
 * Grants access to configuring GraphQL Compose on the defined servers.
 */
class GraphQLComposeAccessCheck implements AccessInterface {

  /**
   * Checks access.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged in account.
   * @param \Drupal\graphql\Entity\ServerInterface $graphql_server
   *   The server instance (optional for upgrade compatibility).
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account, ?ServerInterface $graphql_server = NULL) {
    $result = AccessResult::forbidden();
    $schema = $graphql_server?->get('schema') ?: NULL;

    if ($schema === 'graphql_compose') {
      $result = AccessResult::allowedIfHasPermissions($account, [
        'bypass graphql access',
        'administer graphql configuration',
      ], 'OR');
    }

    return $result->addCacheableDependency($graphql_server);
  }

}
