<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attribute for entity field plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FieldType extends Plugin {

  /**
   * Constructs a new field type plugin.
   *
   * @param string $id
   *   The machine name of the field type. eg text_long.
   * @param null|string|\Stringable $description
   *   (optional) A description to use when the field is used in the schema.
   * @param string|null $type_sdl
   *   (optional) The schema type this field should return.
   * @param string|null $name_sdl
   *   (optional) The name to use for the field in the schema.
   * @param class-string|null $deriver
   *   (optional) The deriver class for the entity type.
   * @param array $third_party_settings
   *   (optional) Third party settings.
   */
  public function __construct(
    public readonly string $id,
    public readonly null|string|\Stringable $description = NULL,
    public readonly ?string $type_sdl = NULL,
    public readonly ?string $name_sdl = NULL,
    public readonly ?string $deriver = NULL,
    public readonly array $third_party_settings = [],
  ) {}

}
